# 帳票設計書 19-Daily Build Group Report

## 概要

本ドキュメントは、GitLabにおけるDaily Build Group Report機能の帳票設計書である。日次ビルドグループレポートを生成する機能について、データ構造、処理フローを定義する。

### 本帳票の処理概要

Daily Build Group Reportは、CIパイプラインで実行されたビルドジョブのカバレッジ情報を日次で集計・保存するレポートである。ビルドグループ（ジョブ名の共通部分）ごとにカバレッジの平均値を計算し、時系列データとして蓄積する。

**業務上の目的・背景**：コードカバレッジの推移を日次で追跡し、コード品質の継続的な監視を可能にする。このレポートにより、カバレッジの傾向分析、目標値との比較、ブランチ別のカバレッジ状況の把握が可能となる。テスト戦略の効果測定やカバレッジ目標の達成度モニタリングに活用される。

**帳票の利用シーン**：プロジェクトのカバレッジトレンドを分析する場合、デフォルトブランチのカバレッジを継続監視する場合、グループ全体のカバレッジ状況を把握する場合などで利用される。

**主要な出力内容**：
1. プロジェクトID
2. 参照パス（ブランチ/タグ）
3. 日付
4. グループ名（ジョブグループ）
5. カバレッジ値（平均）
6. デフォルトブランチフラグ

**帳票の出力タイミング**：パイプライン完了後にサービスが呼び出され、データベースにupsert（挿入または更新）される。

**帳票の利用者**：開発者、QAエンジニア、プロジェクトマネージャー

## 帳票種別

JSON出力（データベース保存）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | プロジェクト分析 | `/:namespace/:project/-/analytics/code_reviews` | カバレッジグラフ表示 |
| - | グループ分析 | `/:group/-/analytics/ci_cd` | グループカバレッジグラフ表示 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | データベーステーブル（ci_daily_build_group_report_results） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | データベースUPSERT |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

データベースレコード構造

```json
{
  "project_id": 1,
  "ref_path": "refs/heads/main",
  "date": "2026-01-22",
  "group_name": "rspec",
  "data": {
    "coverage": 85.50
  },
  "last_pipeline_id": 12345,
  "default_branch": true,
  "group_id": 1
}
```

### ヘッダー部

N/A（データベースレコード）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | project_id | プロジェクトID | pipeline.project_id | 数値 |
| 2 | ref_path | 参照パス | pipeline.source_ref_path | 文字列 |
| 3 | date | 日付 | pipeline.created_at.to_date | 日付 |
| 4 | group_name | グループ名 | build.group_name | 文字列 |
| 5 | coverage | カバレッジ値 | 平均計算 | 小数（2桁） |
| 6 | last_pipeline_id | 最終パイプラインID | pipeline.id | 数値 |
| 7 | default_branch | デフォルトブランチ | pipeline.default_branch? | boolean |
| 8 | group_id | グループID | pipeline.project.group.id | 数値 |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パイプライン完了 | パイプラインが完了状態 | Yes |
| カバレッジ有り | ビルドにカバレッジ値が存在 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | date | 降順 |
| 2 | group_name | 昇順 |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ci_pipelines | パイプライン情報 | 主テーブル |
| ci_builds | ビルド情報 | pipeline_id = ci_pipelines.id |
| projects | プロジェクト情報 | id = ci_pipelines.project_id |
| namespaces | グループ情報 | id = projects.namespace_id |

### テーブル別参照項目詳細

#### ci_builds

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| coverage | coverage | coverage IS NOT NULL | ビルドのカバレッジ値 |
| name | group_name | - | ジョブ名からグループ名を導出 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| average_coverage | グループ内ビルドのcoverage合計 / ビルド数 | 小数点以下2桁（四捨五入） | group_byでジョブ名グルーピング |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[パイプライン完了] --> B[DailyBuildGroupReportResultService#execute]
    B --> C[カバレッジ付きビルド取得]
    C --> D[group_nameでグルーピング]
    D --> E[グループ別平均カバレッジ計算]
    E --> F[レポートデータ生成]
    F --> G[DailyBuildGroupReportResult.upsert_reports]
    G --> H[Projects::CiFeatureUsage記録]
    H --> I[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | カバレッジ付きビルドがない | - | 処理スキップ |
| upsert失敗 | DB制約違反 | エラーログ出力 | データ整合性確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | ビルドグループ数 × 日数 |
| 目標出力時間 | 500ms以内 |
| 同時出力数上限 | パイプライン完了イベント単位 |

## セキュリティ考慮事項

- カバレッジ値のみを保存し、ソースコード情報は含まない
- プロジェクト権限に基づいてデータアクセスを制御

## 備考

- upsert_allで既存データを更新（同一project_id, ref_path, date, group_nameの組み合わせ）
- Projects::CiFeatureUsageでカバレッジ機能の利用状況を追跡

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

日次ビルドグループレポートのデータモデルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | daily_build_group_report_result.rb | `app/models/ci/daily_build_group_report_result.rb` | モデル定義。belongs_to関連、スコープ、upsert_reportsメソッド |

**読解のコツ**: store_accessorでdata JSONカラムからcoverageを取得。upsert_allでユニーク制約に基づいてupsert。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | daily_build_group_report_result_service.rb | `app/services/ci/daily_build_group_report_result_service.rb` | メインサービス。execute()がエントリーポイント |

**主要処理フロー**:
1. **5-12行目**: executeメソッド - upsert_reportsを呼び出し、成功時にCiFeatureUsageを記録
2. **16-35行目**: coverage_reportsメソッド - ベース属性とグループ別カバレッジを組み合わせ
3. **38-40行目**: aggregateメソッド - group_nameでビルドをグルーピング
4. **42-45行目**: average_coverageメソッド - グループ内平均計算

### プログラム呼び出し階層図

```
Ci::DailyBuildGroupReportResultService#execute
    │
    ├─ coverage_reports(pipeline)
    │      ├─ base_attrs (project_id, ref_path, date, etc.)
    │      │
    │      ├─ aggregate(pipeline.builds.with_coverage)
    │      │      └─ builds.group_by(&:group_name)
    │      │
    │      └─ average_coverage(group)
    │             └─ (total_coverage / group.size).round(2)
    │
    ├─ DailyBuildGroupReportResult.upsert_reports(data)
    │      └─ upsert_all(unique_by: :index_...)
    │
    └─ Projects::CiFeatureUsage.insert_usage
           └─ feature: :code_coverage
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ci_pipelines ─────────────▶ DailyBuildGroupReportResultService
                                   │
ci_builds ────────────────▶        ├─ coverage_reports
(with_coverage)                    │      ├─ base_attrs生成
                                   │      ├─ group_nameでグルーピング
                                   │      └─ 平均カバレッジ計算
                                   │
                                   └─ upsert_reports
                                          │
                                          ↓
                           ci_daily_build_group_report_results
                                   │
                                   ├─ project_id
                                   ├─ ref_path
                                   ├─ date
                                   ├─ group_name
                                   ├─ data.coverage
                                   ├─ last_pipeline_id
                                   ├─ default_branch
                                   └─ group_id
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| daily_build_group_report_result_service.rb | `app/services/ci/daily_build_group_report_result_service.rb` | ソース | メインサービス |
| daily_build_group_report_result.rb | `app/models/ci/daily_build_group_report_result.rb` | ソース | モデル |
| ci_feature_usage.rb | `app/models/projects/ci_feature_usage.rb` | ソース | 機能利用追跡 |
| pipeline.rb | `app/models/ci/pipeline.rb` | ソース | パイプラインモデル |
| build.rb | `app/models/ci/build.rb` | ソース | ビルドモデル（coverageスコープ） |
